/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorageTab;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.common.CommonEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.data.DataGenerators;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModCompat;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.init.ModLoot;
import net.p3pp3rf1y.sophisticatedstorage.init.ModParticles;
import net.p3pp3rf1y.sophisticatedstorage.item.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.network.StoragePacketHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sophisticatedstorage")
public class SophisticatedStorage {
    public static final String MOD_ID = "sophisticatedstorage";
    public static final Logger LOGGER = LogManager.getLogger((String)"sophisticatedstorage");
    public static final StoragePacketHandler PACKET_HANDLER = new StoragePacketHandler("sophisticatedstorage");
    public static final CreativeModeTab CREATIVE_TAB = new SophisticatedStorageTab();
    private final CommonEventHandler commonEventHandler = new CommonEventHandler();

    public SophisticatedStorage() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(Config.COMMON::onConfigReload);
        this.commonEventHandler.registerHandlers();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.registerHandlers();
        }
        ModBlocks.registerHandlers(modBus);
        ModItems.registerHandlers(modBus);
        modBus.addListener(SophisticatedStorage::setup);
        modBus.addListener(DataGenerators::gatherData);
        modBus.addListener(CapabilityStorageWrapper::onRegister);
        ModParticles.registerParticles(modBus);
        modBus.addGenericListener(Block.class, ModLoot::registerLootFunction);
    }

    private static void setup(FMLCommonSetupEvent event) {
        PACKET_HANDLER.init();
        ModCompat.initCompats();
    }

    public static ResourceLocation getRL(String regName) {
        return new ResourceLocation(SophisticatedStorage.getRegistryName(regName));
    }

    public static String getRegistryName(String regName) {
        return "sophisticatedstorage:" + regName;
    }
}

